\name{fitCons.UCSC.hg19-package}
\alias{fitCons.UCSC.hg19-package}
\alias{fitCons.UCSC.hg19}
\docType{package}

\title{
Annotation package for UCSC human fitCons scores of fitness consequence of functional annotations
}
\description{
This annotation package stores fitCons scores from UCSC for the
human genome (hg19), corresponding to fitness consequences of functional
annotations. The data are stored in the form of \code{\link[S4Vectors]{Rle}}
objects and are loaded automatically as an object of class
\code{\link[GenomicScores]{GScores}}. The name of the exposed object
matches the name of the package and part of the filename that contained the data
imported into the package. The class definition and methods to access
\code{\link[GenomicScores]{GScores}} objects are found in the
\code{\link[GenomicScores]{GenomicScores}} software package.
}

\format{
  \tabular{ll}{
    \code{\link{fitCons.UCSC.hg19}} \tab GScores object containing
    fitCons conservation scores
    from UCSC for the human genome (hg19)
    downloaded on March 2018 from
    \url{http://http://siepellab.labsites.cshl.edu}. \cr
  }
}

\author{
R. Castelo
}

\seealso{
  \code{\link[GenomicScores]{GScores}}
  \code{\link[GenomicScores]{GenomicScores}}
}

\examples{
library(GenomicRanges)
library(fitCons.UCSC.hg19)

ls("package:fitCons.UCSC.hg19")

fitcons <- fitCons.UCSC.hg19
citation(fitcons)
gscores(fitcons, GRanges("chr7:117232380-117232384"))
}

\source{
  Gulko B, Gronau I, Hubisz MJ, Siepel A. Probabilities of fitness consequences
  for point mutations across the human genome. Nat. Genet. 2015 Aug;47:276-83.
  (http://www.nature.com/ng/journal/v47/n3/full/ng.3196.html)

  CSHL website of the Siepel Lab
  (URL: \url{http://http://siepellab.labsites.cshl.edu}) [March, 2018, accessed]
}

\keyword{package}
\keyword{data}
