datacache <- new.env(hash=TRUE, parent=emptyenv())

clariomshumanhttranscriptcluster <- function() showQCData("clariomshumanhttranscriptcluster", datacache)
clariomshumanhttranscriptcluster_dbconn <- function() dbconn(datacache)
clariomshumanhttranscriptcluster_dbfile <- function() dbfile(datacache)
clariomshumanhttranscriptcluster_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
clariomshumanhttranscriptcluster_dbInfo <- function() dbInfo(datacache)

clariomshumanhttranscriptclusterORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "clariomshumanhttranscriptcluster.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "clariomshumanhttranscriptcluster", "chip clariomshumanhttranscriptcluster", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("clariomshumanhttranscriptcluster.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(clariomshumanhttranscriptcluster_dbconn())
}

