datacache <- new.env(hash=TRUE, parent=emptyenv())

clariomdhumanprobeset <- function() showQCData("clariomdhumanprobeset", datacache)
clariomdhumanprobeset_dbconn <- function() dbconn(datacache)
clariomdhumanprobeset_dbfile <- function() dbfile(datacache)
clariomdhumanprobeset_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
clariomdhumanprobeset_dbInfo <- function() dbInfo(datacache)

clariomdhumanprobesetORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "clariomdhumanprobeset.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "clariomdhumanprobeset", "chip clariomdhumanprobeset", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("clariomdhumanprobeset.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(clariomdhumanprobeset_dbconn())
}

