
\name{bovine_dbconn}

\alias{bovine_dbconn}
\alias{bovine_dbfile}
\alias{bovine_dbschema}
\alias{bovine_dbInfo}


\title{Collect information about the package annotation DB}

\description{
  Some convenience functions for getting a connection object to (or collecting
  information about) the package annotation DB.
}

\usage{
  bovine_dbconn()
  bovine_dbfile()
  bovine_dbschema(file="", show.indices=FALSE)
  bovine_dbInfo()
}

\arguments{
  \item{file}{
    A connection, or a character string naming the file to print to (see
    the \code{file} argument of the \code{\link[base]{cat}} function for
    the details).
  }
  \item{show.indices}{
    The CREATE INDEX statements are not shown by default.
    Use \code{show.indices=TRUE} to get them.
  }
}

\details{
  \code{bovine_dbconn} returns a connection object to the
  package annotation DB.  IMPORTANT: Don't call
  \code{\link[DBI:dbConnect]{dbDisconnect}} on the connection object
  returned by \code{bovine_dbconn} or you will break all the
  \code{\link[AnnotationDbi:AnnDbObj-class]{AnnDbObj}} objects defined
  in this package!

  \code{bovine_dbfile} returns the path (character string) to the
  package annotation DB (this is an SQLite file).

  \code{bovine_dbschema} prints the schema definition of the
  package annotation DB.

  \code{bovine_dbInfo} prints other information about the package
  annotation DB.
}

\value{
  \code{bovine_dbconn}: a DBIConnection object representing an
  open connection to the package annotation DB.

  \code{bovine_dbfile}: a character string with the path to the
  package annotation DB.

  \code{bovine_dbschema}: none (invisible \code{NULL}).

  \code{bovine_dbInfo}: none (invisible \code{NULL}).
}

\seealso{
  \code{\link[DBI:dbSendQuery]{dbGetQuery}},
  \code{\link[DBI:dbConnect]{dbConnect}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbconn}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbfile}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbschema}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbInfo}}
}

\examples{
  library(DBI)
  ## Count the number of rows in the "probes" table:
  dbGetQuery(bovine_dbconn(), "SELECT COUNT(*) FROM probes")

  bovine_dbschema()

  bovine_dbInfo()
}

\keyword{utilities}
\keyword{datasets}

