datacache <- new.env(hash=TRUE, parent=emptyenv())

adme16cod <- function() showQCData("adme16cod", datacache)
adme16cod_dbconn <- function() dbconn(datacache)
adme16cod_dbfile <- function() dbfile(datacache)
adme16cod_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
adme16cod_dbInfo <- function() dbInfo(datacache)

adme16codORGANISM <- "Rattus norvegicus"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "adme16cod.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("RATCHIP_DB", "adme16cod", "chip adme16cod", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("adme16cod.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(adme16cod_dbconn())
}

