#!/bin/sh
#
# To run this script in "batch" mode:
#   ./make_rdas.sh >make_rdas.log 2>&1 &
#

set -e  # Exit immediately if a simple command exits with a non-zero status

## Settings for the rhinos:
PKGNAME="XtraSNPlocs.Hsapiens.dbSNP144.GRCh38"
REFPKGNAME="SNPlocs.Hsapiens.dbSNP144.GRCh38"
SNPLOCSFORGE_DIR="/fh/fast/morgan_m/BioC/SNPlocsForge"
TOOLS_DIR="$SNPLOCSFORGE_DIR/svn/$PKGNAME/inst/tools"
DOWNLOAD_DIR="$SNPLOCSFORGE_DIR/srcdata/$REFPKGNAME/downloads"
TMP_DIR="$SNPLOCSFORGE_DIR/srcdata/$REFPKGNAME/tmp_files"

#SHORTSEQNAMES="Y MT"
SHORTSEQNAMES="1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 X Y MT"

R="$HOME/bin/R"
R_SCRIPT0="source('$TOOLS_DIR/utils.R')"

for chr in $SHORTSEQNAMES; do
    src_file="$DOWNLOAD_DIR/ds_flat_ch${chr}.flat"
    raw_xtra_snps_file="$TMP_DIR/ch${chr}_raw_xtra_snps.txt"
    echo -n "Extracting raw xtra SNPs from $src_file ... "
    $TOOLS_DIR/filter1_ds_flat.sh <$src_file | \
      $TOOLS_DIR/filter2_ds_flat | \
      $TOOLS_DIR/filter3_ds_flat.sh $chr >$raw_xtra_snps_file
    echo "OK"
done

R_SCRIPT="$R_SCRIPT0; loadAndSerializeXtraSNPs('$TMP_DIR', '$SHORTSEQNAMES')"
echo "$R_SCRIPT" | $R --vanilla

