\name{TxDb.Celegans.UCSC.ce11.ensGene}
\docType{package}

\alias{TxDb.Celegans.UCSC.ce11.ensGene-package}
\alias{TxDb.Celegans.UCSC.ce11.ensGene}
\alias{TxDb.Celegans.UCSC.ce11.ensGene}


\title{Annotation package for TxDb object(s)}

\description{  
  This package loads one or more TxDb objects.  Such TxDb
  objects are an R interface to prefabricated databases contained by
  this package.

  The names of any objects exposed by this package indicate the origin and
  resources exposed.  So for example TxDb.Hsapiens.UCSC.hg19.knownGene
  would be a TxDb object, of Homo sapiens data from UCSC build
  hg19 based on the knownGene Track.
}

\note{
  This data package was made from resources at UCSC on
  2022-04-15 17:21:59 +0000 (Fri, 15 Apr 2022) and based on the ce11 genome based on the ensGene table
}

\author{Bioconductor Core Team, Bioconductor Package Maintainer <maintainer@bioconductor.org> [cre]}


\seealso{
  \link[GenomicFeatures]{transcripts},
  \link[GenomicFeatures]{transcriptsBy}
}

\examples{
## load the library
library(TxDb.Celegans.UCSC.ce11.ensGene)
## list the contents that are loaded into memory
ls('package:TxDb.Celegans.UCSC.ce11.ensGene')
## show the db object that is loaded by calling it's name
TxDb.Celegans.UCSC.ce11.ensGene

}

\keyword{package}
\keyword{data}
