% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allMethods.R
\name{mapIds,SomaDb-method}
\alias{mapIds,SomaDb-method}
\alias{mapIds}
\title{The \code{mapIds} method for \code{SomaDb} objects}
\usage{
\S4method{mapIds}{SomaDb}(
  x,
  keys,
  column,
  keytype,
  menu = NULL,
  match = FALSE,
  ...,
  multiVals = c("filter", "asNA", "first", "list", "CharacterList")
)
}
\arguments{
\item{x}{the \code{AnnotationDb} object. But in practice this will mean an 
    object derived from an \code{AnnotationDb} object such as a \code{OrgDb} or 
    \code{ChipDb} object.}

\item{keys}{the keys to select records for from the database.  All possible 
    keys are returned by using the \code{keys} method.}

\item{column}{the column to search on (for \code{mapIds}).  Different from 
    \code{columns} in that it can only have a single element for the value}

\item{keytype}{the keytype that matches the keys used.  For the
    \code{select} methods, this is used to indicate the kind of ID being used
    with the keys argument. For the \code{keys} method this is used to
    indicate which kind of keys are desired from \code{keys}
  }

\item{menu}{a character string identifying a SomaScan menu
version (optional). Possible options include: \code{"5k"},\code{"7k"}, or \code{"11k"},
as well as the version numbers for those menus (\code{"v4.0"}, \code{"v4.1"}, or
\code{"v5.0"}, respectively). May only be used when \code{keytype = "PROBEID"}.
This argument will filter the keys to the specified menu and only return
data associated with analytes present in that menu. By default, all
annotations from all analytes are available.}

\item{match}{a logical (TRUE/FALSE). Must be used with the "SYMBOL",
"ALIAS", or "GENENAME" keytypes only. If true, the character string
provided for \code{keys} will be used as a search term. The string will be
used to match symbols that also start with that string (ex. a key of
"CASP1" will return annotations for both the CASP10 & CASP14 genes).}

\item{...}{
  Arguments passed on to \code{\link[AnnotationDbi:AnnotationDb-class]{AnnotationDbi::mapIds}}
  \describe{
    \item{\code{}}{}
  }}

\item{multiVals}{What should \code{mapIds} do when there are multiple values         
  that could be returned?  Options include:
    \describe{
      \item{first:}{This value means that when there are multiple matches only the 1st thing that comes back will be returned. This is the default behavior}
      \item{list:}{This will just returns a list object to the end user}
      \item{filter:}{This will remove all elements that contain multiple matches and will therefore return a shorter vector than what came in whenever some of the keys match more than one value}
      \item{asNA:}{This will return an NA value whenever there are multiple matches}
      \item{CharacterList:}{This just returns a SimpleCharacterList object}
      \item{FUN:}{You can also supply a function to the \code{multiVals} argument for custom behaviors.  The function must take a single argument and return a single value.  This function will be applied to all the elements and will serve a 'rule' that for which thing to keep when there is more than one element.  So for example this example function will always grab the last element in each result: \code{ last <- function(x){x[[length(x)]]} }
      }
    }
  }
}
\value{
A named character vector containing the retrieved annotations.
Missing values will be returned as \code{NA}.
}
\description{
\code{mapIds} will retrieve SomaScan annotations (as a named vector) based on
the parameters provided by the \code{keys}, \code{columns}, and \code{keytype} arguments.
The default keytype is "PROBEID", e.g. the SomaLogic \code{SeqId}; this value
will be used to tie all annotations back to a SomaScan-specific identifier.
}
\details{
\code{mapIds} is similar to \code{select} in that it can be used to retrieve
annotation information from the database. However, users should be aware
that if they call \code{mapIds} and request columns that have multiple matches
for the specified keys (ex. GO or other pathway-related terms), \code{mapIds}
will return a named character vector with (by default) \emph{only one} result
for each possible match. This result in some results being truncated. Make
sure to specify the appropriate \code{multiVals} parameter for each query.
}
\examples{
# Retrieve a set of example keys
keys <- head(keys(SomaScan.db))
keys

# Only 1 result is returned by default; missing values are returned as `NA`
mapIds(SomaScan.db, keys = keys, column = "UNIPROT")

# Specify `multiVals` to return all results as a list
mapIds(SomaScan.db, keys = keys, column = "UNIPROT", multiVals = "list")
}
\author{
Amanda Hiser
}
