#!/bin/sh
#
# To run this script in "batch" mode:
#   ./make_tmp_files.sh >make_tmp_files.log 2>&1 &
#

set -e  # Exit immediately if a simple command exits with a non-zero status

## Settings for the rhinos:
PKGNAME="SNPlocs.Hsapiens.dbSNP144.GRCh38"
SNPLOCSFORGE_DIR="/fh/fast/morgan_m/BioC/SNPlocsForge"
TOOLS_DIR="$SNPLOCSFORGE_DIR/svn/$PKGNAME/inst/tools"
DOWNLOAD_DIR="$SNPLOCSFORGE_DIR/srcdata/$PKGNAME/downloads"
TMP_DIR="$SNPLOCSFORGE_DIR/srcdata/$PKGNAME/tmp_files"

#SEQNAMES="22 MT"
SEQNAMES="1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 X Y MT"

echo
echo "********************** START make_tmp_files **********************"
date
echo

for seqname in $SEQNAMES; do
    src_file="$DOWNLOAD_DIR/ds_flat_ch${seqname}.flat"
    raw_snps_file="$TMP_DIR/ch${seqname}_raw_snps.txt"
    echo -n "Extracting raw SNPs from $src_file ... "
    $TOOLS_DIR/filter1_ds_flat.sh <$src_file | \
      $TOOLS_DIR/filter2_ds_flat | \
      $TOOLS_DIR/filter3_ds_flat.sh $seqname >$raw_snps_file
    echo "OK"
done

echo
echo "*********************** END make_tmp_files ***********************"
date

