###
###

.genome <- "GRCh37.p13"

.onLoad <- function(libname, pkgname)
{
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make Seqinfo object.
    seqinfo_path <- file.path(extdata_dirpath, "seqinfo.txt")
    seqinfo <- BSgenome:::read_seqinfo_table(seqinfo_path, .genome)

    ## Make GenomeDescription object. See
    ##   https://www.ncbi.nlm.nih.gov/assembly/GCF_000001405.25/
    ## for more information about GRCh37.p13.
    reference_genome <- GenomeDescription(
        organism="Homo sapiens",
        common_name="Human",
        provider="NCBI",
        provider_version=.genome,
        release_date="2013-06-28",
        release_name="GRCh37 Patch Release 13",
        seqinfo=seqinfo
    )

    ## Make list of "sequence name translation tables".
    seqlevels <- seqlevels(seqinfo)
    compatible_genomes <- list(
        BSgenome.Hsapiens.UCSC.hg19=
            structure(seqlevels[-length(seqlevels)],
                      names=paste0("chr", c(1:22, "X", "Y")))
    )

    ## Make and export SNPlocs object.
    snps <- newSNPlocs(
        provider="dbSNP",
        provider_version="dbSNP Human BUILD 144",
        release_date="June 2015",
        release_name="dbSNP Human BUILD 144",
        source_data_url="ftp://ftp.ncbi.nih.gov/snp/organisms/human_9606_b144_GRCh37p13/ASN1_flat/",
        download_date="July 24, 2015",
        reference_genome=reference_genome,
        compatible_genomes=compatible_genomes,
        data_pkgname=pkgname,
        data_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, snps, envir=ns)
    namespaceExport(ns, objname)

    ## - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
    ## TODO: Remove all the functions below in BioC 3.6
    ##

    ## Define and export getSNPcount().
    getSNPcount <- function()
    {
        msg <- wmsg("SNPlocs.Hsapiens.dbSNP144.GRCh37::getSNPcount() is ",
                    "defunct. Please use\n\n",
                    "  snps <- SNPlocs.Hsapiens.dbSNP144.GRCh37\n\n",
                    "  snpcount(snps)\n\n",
                    "instead. See '?snpcount' for more information.")
        .Defunct(msg=msg)
    }
    objname <- "getSNPcount"
    assign(objname, getSNPcount, envir=ns)
    namespaceExport(ns, objname)

    ## Define and export getSNPlocs().
    getSNPlocs <- function(seqname, as.GRanges=FALSE, caching=TRUE)
    {
        msg <- wmsg("SNPlocs.Hsapiens.dbSNP144.GRCh37::getSNPlocs() is ",
                    "defunct. Please use the SNPlocs API instead. ",
                    "See '?snpcount' for more information.")
        .Defunct(msg=msg)
    }
    objname <- "getSNPlocs"
    assign(objname, getSNPlocs, envir=ns)
    namespaceExport(ns, objname)

    ## Define and export rsid2loc(), rsid2alleles(), and rsidsToGRanges().
    rsid2loc <- function(rsids, caching=TRUE)
    {
        msg <- wmsg("SNPlocs.Hsapiens.dbSNP144.GRCh37::rsid2loc() is ",
                    "defunct. Please use the SNPlocs API instead. ",
                    "See '?snpcount' for more information.")
        .Defunct(msg=msg)
    }
    objname <- "rsid2loc"
    assign(objname, rsid2loc, envir=ns)
    namespaceExport(ns, objname)

    rsid2alleles <- function(rsids, caching=TRUE)
    {
        msg <- wmsg("SNPlocs.Hsapiens.dbSNP144.GRCh37::rsid2alleles() is ",
                    "defunct. Please use the SNPlocs API instead. ",
                    "See '?snpcount' for more information.")
        .Defunct(msg=msg)
    }
    objname <- "rsid2alleles"
    assign(objname, rsid2alleles, envir=ns)
    namespaceExport(ns, objname)

    rsidsToGRanges <- function(rsids, caching=TRUE)
    {
        msg <- wmsg("SNPlocs.Hsapiens.dbSNP144.GRCh37::rsidsToGRanges() is ",
                    "defunct. Please use the SNPlocs API instead. ",
                    "See '?snpcount' for more information.")
        .Defunct(msg=msg)
    }
    objname <- "rsidsToGRanges"
    assign(objname, rsidsToGRanges, envir=ns)
    namespaceExport(ns, objname)

    ## - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
    ## SNP injection interface (see BSgenome package for how this interface
    ## is used).
    ## TODO: The SNP injection mechanism needs to be modernized and the
    ## modernized version should not use this ugly interface anymore.
    ##

    ## Define and export .loadLoc() and .loadAlleles().
    .loadLoc <- function(seqname)
        BSgenome:::.load_raw_snplocs(snps, seqname, TRUE)$loc
    objname <- ".loadLoc"
    assign(objname, .loadLoc, envir=ns)
    namespaceExport(ns, objname)

    .loadAlleles <- function(seqname)
        BSgenome:::.load_raw_snplocs(snps, seqname, TRUE)$alleles
    objname <- ".loadAlleles"
    assign(objname, .loadAlleles, envir=ns)
    namespaceExport(ns, objname)

    ## Export 'compatible_genomes' as 'COMPATIBLE_BSGENOMES'.
    objname <- "COMPATIBLE_BSGENOMES"
    assign(objname, compatible_genomes, envir=ns)
    namespaceExport(ns, objname)    
}

