\name{SIFT.Hsapiens.dbSNP132}
\docType{package}

\alias{SIFT.Hsapiens.dbSNP132-package}
\alias{SIFT.Hsapiens.dbSNP132}


\title{SIFT predictions for Homo sapiens dbSNP build 132}

\description{Database of SIFT predictions for Homo sapiens dbSNP build 132}

\details{
  \itemize{
    \item Methods :
      See ?'SIFTDb-class' for methods.

    \item Creation of Database Tables :
      This package includes SIFT predictions for dbSNP build 132 human 
      coding non-synonymous SNPs. 

    \item Source Files :
      \itemize{
        \item Source : 
              ftp://ftp.jcvi.org/pub/data/sift/dbSNP_132/
        \item Software : SIFT 4.0.3
        \item Databases :
            PSI-BLAST 
        \item Source Files :
         collated_predictions_dbSNP132.tgz 
            SIFT predictions for all snps in dbSNP build 132
         readme_collated_predictions_dbSNP132.txt
            description of data columns
        \item Description :
          This package contains SIFT annotations for 437544 human SNPs included
          in dbSNP build 132.
      }
  }
}


\references{
  SIFT Home:
  \url{http://sift.jcvi.org/}

  Kumar P, Henikoff S, Ng PC. Predicting the effects of coding non-synonymous
  variants on protein function using the SIFT algorithm. Nat Protoc.
  2009;4(7):1073-81

  Ng PC, Henikoff S. Predicting the Effects of Amino Acid Substitutions on Protein
  Function Annu Rev Genomics Hum Genet. 2006;7:61-80.

  Ng PC, Henikoff S. SIFT: predicting amino acid changes that affect protein
  function. Nucleic Acids Res. 2003 Jul 1;31(13):3812-4.
}

\author{Valerie Obenchain <vobencha@fhcrc.org>}

\seealso{
  \link[VariantAnnotation]{SIFTDb-class}

  see ? \code{SIFTDbColumns} for column descriptions
}

\examples{
  library(SIFT.Hsapiens.dbSNP132)

  ## metadata
  metadata(SIFT.Hsapiens.dbSNP132)

  ## column descriptions can be found at ?SIFTDbColumns 
  head(keys(SIFT.Hsapiens.dbSNP132))
  cols(SIFT.Hsapiens.dbSNP132)

  ## subset on keys and cols 
  rsids <- c("rs17970171", "rs2142947", "rs3026284") 
  subst <- c("RSID", "METHOD", "PREDICTION", "SCORE")
  select(SIFT.Hsapiens.dbSNP132, keys=rsids, cols=subst)
  select(SIFT.Hsapiens.dbSNP132, keys=rsids)

}

\keyword{package}
\keyword{data}
