
\name{SHDZ_dbconn}

\alias{SHDZ_dbconn}
\alias{SHDZ_dbfile}
\alias{SHDZ_dbschema}
\alias{SHDZ_dbInfo}


\title{Collect information about the package annotation DB}

\description{
  Some convenience functions for getting a connection object to (or collecting
  information about) the package annotation DB.
}

\usage{
  SHDZ_dbconn()
  SHDZ_dbfile()
  SHDZ_dbschema(file="", show.indices=FALSE)
  SHDZ_dbInfo()
}

\arguments{
  \item{file}{
    A connection, or a character string naming the file to print to (see
    the \code{file} argument of the \code{\link[base]{cat}} function for
    the details).
  }
  \item{show.indices}{
    The CREATE INDEX statements are not shown by default.
    Use \code{show.indices=TRUE} to get them.
  }
}

\details{
  \code{SHDZ_dbconn} returns a connection object to the
  package annotation DB.  IMPORTANT: Don't call
  \code{\link[DBI:dbConnect]{dbDisconnect}} on the connection object
  returned by \code{SHDZ_dbconn} or you will break all the
  \code{\link[AnnotationDbi:AnnDbObj-class]{AnnDbObj}} objects defined
  in this package!

  \code{SHDZ_dbfile} returns the path (character string) to the
  package annotation DB (this is an SQLite file).

  \code{SHDZ_dbschema} prints the schema definition of the
  package annotation DB.

  \code{SHDZ_dbInfo} prints other information about the package
  annotation DB.
}

\value{
  \code{SHDZ_dbconn}: a DBIConnection object representing an
  open connection to the package annotation DB.

  \code{SHDZ_dbfile}: a character string with the path to the
  package annotation DB.

  \code{SHDZ_dbschema}: none (invisible \code{NULL}).

  \code{SHDZ_dbInfo}: none (invisible \code{NULL}).
}

\seealso{
  \code{\link[DBI:dbSendQuery]{dbGetQuery}},
  \code{\link[DBI:dbConnect]{dbConnect}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbconn}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbfile}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbschema}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbInfo}}
}

\examples{
  library(DBI)
  ## Count the number of rows in the "probes" table:
  dbGetQuery(SHDZ_dbconn(), "SELECT COUNT(*) FROM probes")

  SHDZ_dbschema()

  SHDZ_dbInfo()
}

\keyword{utilities}
\keyword{datasets}

