datacache <- new.env(hash=TRUE, parent=emptyenv())

RnAgilentDesign028282 <- function() showQCData("RnAgilentDesign028282", datacache)
RnAgilentDesign028282_dbconn <- function() dbconn(datacache)
RnAgilentDesign028282_dbfile <- function() dbfile(datacache)
RnAgilentDesign028282_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
RnAgilentDesign028282_dbInfo <- function() dbInfo(datacache)

RnAgilentDesign028282ORGANISM <- "Rattus norvegicus"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "RnAgilentDesign028282.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("RATCHIP_DB", "RnAgilentDesign028282", "chip RnAgilentDesign028282", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("RnAgilentDesign028282.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(RnAgilentDesign028282_dbconn())
}

