\name{RmiR.hsa_dbconn}

\alias{RmiR.hsa_dbconn}
\alias{RmiR.hsa_dbfile}

\title{Collect information from different
 miRNA targets databases}

\description{
  A function to get a connection object to some miRNA targets databases.  
} 

\usage{
  RmiR.hsa_dbconn()
  RmiR.hsa_dbfile()
}

\details{
  \code{RmiR.hsa_dbconn} returns a connection object to some miRNA targets databases.  
  IMPORTANT: Do not call \code{\link[DBI]{dbDisconnect}} on the connection 
  object returned by \code{RmiR.hsa_dbconn} or you will 
  break all the \code{\link[AnnotationDbi]{AnnDbObj}} objects defined in this package!
  
  \code{RmiR.hsa_dbfile} returns the path (character string) to the 
  package annotation DB (this is an SQLite v3 file). 
}

\value{
 \item{RmiR.hsa_dbconn}{A DBIConnection object representing an open
  connection to the miRNA targets database.}
  
  \item{RmiR.hsa_dbfile}{A character string with the path to the miRNA
  targets database.}
}

\seealso{
  \code{\link[DBI]{dbGetQuery}},
  \code{\link[DBI]{dbConnect}},
  \code{\link[AnnotationDbi]{dbconn}},
  \code{\link[AnnotationDbi]{dbfile}}
}

\examples{
  ## List all the tables of the database:
  dbListTables(RmiR.hsa_dbconn())

  ## Count the number of rows in the "targetscan" table:
  dbGetQuery(RmiR.hsa_dbconn(), "SELECT COUNT(*) FROM targetscan")
  
  ## List the contents of the "mirbase" tables:
  dbListFields(RmiR.hsa_dbconn(), "mirbase")

  ## List all targets of "hsa-miR-21" in miranda database:
  dbGetQuery(RmiR.hsa_dbconn(), 
	     "SELECT * FROM tarbase where mature_miRNA='hsa-miR-21'")

  ## The connection object returned by RmiR.hsa_dbconn() was created with:
  dbConnect(SQLite(), dbname=RmiR.hsa_dbfile(), cache_size=64000, synchronous=0)
}

\keyword{utilities}
\keyword{datasets}
