\name{MafDb.ExAC.r1.0.nonTCGA.hs37d5-package}
\alias{MafDb.ExAC.r1.0.nonTCGA.hs37d5-package}
\alias{MafDb.ExAC.r1.0.nonTCGA.hs37d5}
\docType{package}

\title{
Annotation package for minor allele frequency data from the Exome Aggregation Consortium
}
\description{
This annotation package stores minor allele frequency (MAF) data derived from the variant set release 1.0 of the Exome Aggregation Consortium (ExAC), excluding TCGA samples. The data are exposed to the user in the form of a \code{\link[GenomicScores]{GScores}} object, named after the package and loaded into main memory only as different chromosomes and populations are being queried. The class definition and methods to access \code{\link[GenomicScores]{GScores}} objects are found in the \code{\link[GenomicScores]{GenomicScores}} software package. To minimize disk space and memory requirements, MAF values larger or equal than 0.1 are stored using two significant digits, while MAF values smaller than 0.1 are stored using one significant digit.

Please consult the ExAC FAQ page at \url{http://exac.broadinstitute.org/faq} before you use these data for your own research.
}

\format{
  \tabular{ll}{
    \code{\link{MafDb.ExAC.r1.0.nonTCGA.hs37d5}} \tab \code{\link[GenomicScores]{GScores}} object containing MAF values from ExAC downloaded on March 2018 from \url{http://exac.broadinstitute.org/downloads}. See the \code{inst/extdata/README} file from the source code for more information on how these data have been stored into this package. \cr
  }
}

\author{
R. Castelo
}

\seealso{
  \link[GenomicScores]{GScores-class}
  \link[GenomicScores]{gscores}
  \link[GenomicScores]{GenomicScores}
}

\examples{
library(SNPlocs.Hsapiens.dbSNP144.GRCh37)
library(MafDb.ExAC.r1.0.nonTCGA.hs37d5)

ls("package:MafDb.ExAC.r1.0.nonTCGA.hs37d5")

mafdb <- MafDb.ExAC.r1.0.nonTCGA.hs37d5
mafdb
citation(mafdb)

populations(mafdb)

## lookup allele frequencies for rs1129038, a SNP associated to blue and brown eye colors
## as reported by Eiberg et al. Blue eye color in humans may be caused by a perfectly associated
## founder mutation in a regulatory element located within the HERC2 gene inhibiting OCA2 expression.
## Human Genetics, 123(2):177-87, 2008 [http://www.ncbi.nlm.nih.gov/pubmed/18172690]

snpdb <- SNPlocs.Hsapiens.dbSNP144.GRCh37
rng <- snpsById(snpdb, ids="rs1129038")
rng
gscores(mafdb, rng)
gscores(mafdb, GRanges("15:28356859"))
}

\source{
  Lek M et al. Analysis of protein-coding genetic variation in 60,706 humans.
  Nature, 536:285-291, 2016.

  The Exome Aggregation Consortium (ExAC), Cambridge, MA
  (URL: \url{http://exac.broadinstitute.org}) [March, 2018, accessed]
}

\keyword{package}
\keyword{data}
