\name{IlluminaHumanMethylationEPICv2anno.20a1.hg38}
\alias{IlluminaHumanMethylationEPICv2anno.20a1.hg38}
\alias{Locations}
\alias{SNPs.Illumina}
\alias{Manifest}
\alias{Islands.UCSC}
\alias{Other}
\docType{data}
\title{
  Annotation data for the \sQuote{IlluminaHumanMethylationEPIC} micro array.
}
\description{
 This package is based on the file \url{https://support.illumina.com/content/dam/illumina-support/documents/downloads/productfiles/methylationepic/MethylationEPIC\%20v2\%20Files.zip} from 
  \url{https://support.illumina.com/array/array_kits/infinium-methylationepic-beadchip-kit/downloads.html}.

  Additional SNP annotation is generated by the authors (described in \code{\link[IlluminaHumanMethylationEPICv2anno.20a1.hg38]{SNPs.CommonSingle}}).

  A script for creating the data object in this package is contained in
  \code{scripts/createAnno.R}.
}
\format{
  An object of class \code{IlluminaMethylationAnnotation} for
  \code{IlluminaHumanMethylationEPIv2Canno.20a1.hg38}. All others are of
  class \code{DataFrame}
}
\details{
  The following changes/ modifications / addition has been made to the
  source material.

  For the annotation related to UCSC islands, a value of \code{""} has
  been changed to \code{"OpenSea"}.

  The creation of this object based on the Illumina annotation and
  additional SNP information (see \code{\link[IlluminaHumanMethylationEPICv2anno.20a1.hg38]{SNPs.CommonSingle}}) is contained in the
  \code{createAnno.R} script in the \code{scripts} directory.

  Contents of the columns are the responsibility of Illumina; see their
  documentation for details.
}

\source{
  See description.
}

\examples{
IlluminaHumanMethylationEPICv2anno.20a1.hg38
Locations
Manifest
data(SNPs.Illumina)  # data object too large, need to be loaded manually by data()
Islands.UCSC
data(Other)  # data object too large, need to be loaded manually by data()
}
\keyword{datasets}
