% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gencode_txdb.R
\name{gencode_txdb}
\alias{gencode_txdb}
\alias{gencode_source_url}
\title{Create a Gencode TxDb object}
\usage{
gencode_txdb(
  version = "31",
  genome = c("hg38", "hg19"),
  chrs = paste0("chr", c(seq_len(22), "X", "Y", "M"))
)

gencode_source_url(version = "31", genome = c("hg38", "hg19"))
}
\arguments{
\item{version}{A \code{character(1)} with the Gencode version number.}

\item{genome}{A \code{character(1)} with the human genome version number. Valid
options are \code{'hg38'} or \code{'hg19'}.}

\item{chrs}{A \code{character()} vector with the chromosome (contig) names to
keep.}
}
\value{
A \link[GenomicFeatures:TxDb-class]{GenomicFeatures::TxDb} object.

A \code{character(1)} with the URL for the GTF Gencode file of interest.
}
\description{
This function builds a transcript database (\code{TxDb}) object which you can then
use to build a Gencode \code{GenomicState} object. This function will download
the data from Gencode, import it into R, process it and build the \code{TxDb}
object.
}
\examples{

## Start from scratch if you want:
\dontrun{
txdb_v31_hg19_chr21 <- gencode_txdb("31", "hg19", chrs = "chr21")
}

## or read in the txdb object for hg19 chr21 from this package
txdb_v31_hg19_chr21 <- AnnotationDbi::loadDb(
    system.file("extdata", "txdb_v31_hg19_chr21.sqlite",
        package = "GenomicState"
    )
)

## Explore the result
txdb_v31_hg19_chr21

## Locate the GTF file for Gencode version 31 for hg19
gencode_source_url(version = "31", genome = "hg19")
}
\references{
Based on code for the \code{brainflowprobes} package at:
\url{https://github.com/LieberInstitute/brainflowprobes/blob/devel/data-raw/create_sysdata.R}
}
\seealso{
\code{\link[=gencode_annotated_genes]{gencode_annotated_genes()}} \code{\link[=gencode_genomic_state]{gencode_genomic_state()}}
}
\author{
Leonardo Collado-Torres
}
