datacache <- new.env(hash=TRUE, parent=emptyenv())

GGHumanMethCancerPanelv1 <- function() showQCData("GGHumanMethCancerPanelv1", datacache)
GGHumanMethCancerPanelv1_dbconn <- function() dbconn(datacache)
GGHumanMethCancerPanelv1_dbfile <- function() dbfile(datacache)
GGHumanMethCancerPanelv1_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
GGHumanMethCancerPanelv1_dbInfo <- function() dbInfo(datacache)

GGHumanMethCancerPanelv1ORGANISM <- "Homo sapiens"

GGHumanMethCancerPanelv1CPGCOORDINATE <- createSimpleBimap("cpgcoordinates","Probe_ID","CpG_Coordinate",GGHumanMethCancerPanelv1.db:::datacache,"CPGCOORDINATE","GGHumanMethCancerPanelv1.db")
GGHumanMethCancerPanelv1DISTTOTSS <- createSimpleBimap("disttotss","Probe_ID","Dist_to_TSS",GGHumanMethCancerPanelv1.db:::datacache,"DISTTOTSS","GGHumanMethCancerPanelv1.db")
GGHumanMethCancerPanelv1ISCPGISLAND <- createSimpleBimap("iscpgisland","Probe_ID","CpG_island",GGHumanMethCancerPanelv1.db:::datacache,"ISCPGISLAND","GGHumanMethCancerPanelv1.db")

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "GGHumanMethCancerPanelv1.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "GGHumanMethCancerPanelv1", "chip GGHumanMethCancerPanelv1", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("GGHumanMethCancerPanelv1.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(GGHumanMethCancerPanelv1_dbconn())
}

