\name{FDb.UCSC.snp135common.hg19}
\docType{package}

\alias{FDb.UCSC.snp135common.hg19-package}
\alias{FDb.UCSC.snp135common.hg19}

\title{UCSC common SNPs track, dbSNP build 135, genome assembly hg19}

\description{  
  FDb.UCSC.snp135common.hg19 is a FeatureDb created from the UCSC common SNPs 
  track for dbSNP build 135 and genome assembly hg19.  The track is too large 
  to automatically construct a FeatureDb using makeFeatureDbFromUCSC, so here
  it has been manually retrieved (see inst/build/FDb.UCSC.snp135common.hg19.R)
  and saved as a FeatureDb.
}

\author{Tim Triche, Jr.}

\seealso{
  \code{\link[GenomicFeatures]{features}}
  \code{\link[GenomicFeatures]{makeFeatureDbFromUCSC}}
}

\examples{

## load the library
library(FDb.UCSC.snp135common.hg19)

## list the contents that are loaded into memory
ls('package:FDb.UCSC.snp135common.hg19')

## show the db object that is loaded by calling it's name
FDb.UCSC.snp135common.hg19

## extract features for use in annotating data
snp135common <- features(FDb.UCSC.snp135common.hg19)
met <- metadata(FDb.UCSC.snp135common.hg19) ## need to fetch genome
genome(snp135common) <- met[which(met[,'name']=='Genome'),'value']

}

\keyword{package}
\keyword{data}
