getNearestTSS <- function(probes) getNearest(probes, 'tss')

getNearestGene <- function(probes) getNearest(probes, 'gene')

getNearestTranscript <- function(probes) getNearest(probes, 'transcript')

getNearest <- function(probes, what, grl=NULL, ...) {

  if (!is(probes, 'GenomicRanges')) { 
    stop('This function expects a GenomicRanges object as the first argument')
  }

  if (is.null(grl)) {
    grl <- transcriptsBy(TxDb.Hsapiens.UCSC.hg18.knownGene, 'gene')
    names(grl) <- mget(names(grl), org.Hs.egSYMBOL, ifnotfound=NA)
  }

  if (tolower(what) == 'gene') { 
    gr <- unlist(reduce(grl))
  } else if (tolower(what) == 'transcript') {
    gr <- unlist(grl)
  } else if (tolower(what) == 'tss') { 
    gr <- unique(resize(unlist(grl), 1, fix='start'))
  }

  res <- as(distanceToNearest(probes, gr), 'data.frame')
  rownames(res) <- names(probes)[ res$queryHits ]
  res$nearestGeneSymbol <- names(gr)[ res$subjectHits ]
  if (tolower(what) %in% c('transcript','tss')) { 
    res$nearestTranscript <- gr$tx_name[ res$subjectHits ]
  }
  return(res) 

}
