## raw data
require(rtracklayer)
FANTOM4.hg18 <- rtracklayer::import.gff('http://www.swissregulon.unibas.ch/data/hg18/fantom4/promoters.gff', asRangedData=FALSE)
names(values(FANTOM4.hg18)) <- gsub('group','grp',names(values(FANTOM4.hg18)))

## liftOver
data(hg18ToHg19)
FANTOM4.hg19 <- unlist(liftOver(FANTOM4.hg18, hg18ToHg19))
genome(FANTOM4.hg19) <- 'hg19' ## seqinfo gives me fits...

## observed/expected CpG content, 3kb window
source("oecg.R")
require(matrixStats)
require(BSgenome.Hsapiens.UCSC.hg19)
values(FANTOM4.hg19)$oecg <- oecg(Hsapiens, FANTOM4.hg19, bp=3000)
values(FANTOM4.hg19)$phase <- NULL 
values(FANTOM4.hg19)$source <- NULL 
values(FANTOM4.hg19)$score <- NULL 
values(FANTOM4.hg19)$type <- NULL  ## could substitute low/high CpG instead

## write it out 
source('GenomicRangesToFeatureDb.R')
FDb.FANTOM4.promoters.hg19 <- GenomicRangesToFeatureDb(
   FANTOM4.hg19,
   URL='http://www.swissregulon.unibas.ch/cgi-bin/regulon?page=fantom4',
   tableName='FANTOM4',
   src='The FANTOM project at riken.jp and swissregulon.unibas.ch',
   label='CAGE transcription start sites in AML cell line THP-1, lifted to hg19'
)

