###
###

.pkgname <- "BSgenome.Tguttata.UCSC.taeGut1"

.seqnames <- paste0("chr", c(1, "1A", "1B", 2:4, "4A", 5:28, "LGE22", "LG2", "LG5", "Z", "M", "Un", paste0(c(1, "1A", "1B", 2:4, "4A", 5:28, "LGE22", "Z"), "_random")))

.circ_seqs <- "chrM"

.mseqnames <- NULL

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Taeniopygia guttata",
        species="Zebra finch",
        provider="UCSC",
        provider_version="taeGut1",
        release_date="Jul. 2008",
        release_name="WUSTL v3.2.4",
        source_url="http://hgdownload.soe.ucsc.edu/goldenPath/taeGut1/bigZips/",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

    old_objname <- "Tguttata"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}

