###
###

.pkgname <- "BSgenome.Sscrofa.UCSC.susScr3"

.seqnames <- paste0("chr", c(1:18, "X", "Y", "M"))

.circ_seqs <- "chrM"

.mseqnames <- "unplaced_scaffolds"

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Sus scrofa",
        species="Pig",
        provider="UCSC",
        provider_version="susScr3",
        release_date="Aug. 2011",
        release_name="Swine Genome Sequencing Consortium Sscrofa10.2",
        source_url="http://hgdownload.soe.ucsc.edu/goldenPath/susScr3/bigZips/",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

    old_objname <- "Sscrofa"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}

