###
###

.pkgname <- "BSgenome.Scerevisiae.UCSC.sacCer3"

.seqnames <- paste("chr", c("I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X", "XI", "XII", "XIII", "XIV", "XV", "XVI", "M"), sep="")

.circ_seqs <- "chrM"

.mseqnames <- NULL

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Saccharomyces cerevisiae",
        species="Yeast",
        provider="UCSC",
        provider_version="sacCer3",
        release_date="April 2011",
        release_name="SGD April 2011 sequence",
        source_url="http://hgdownload.cse.ucsc.edu/goldenPath/sacCer3/bigZips/",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

    old_objname <- "Scerevisiae"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}

