\name{BSgenome.Rnorvegicus.UCSC.rn6}
\docType{package}

\alias{BSgenome.Rnorvegicus.UCSC.rn6-package}
\alias{BSgenome.Rnorvegicus.UCSC.rn6}
\alias{Rnorvegicus}

\title{Full genome sequences for Rattus norvegicus (UCSC version rn6)}

\description{
  Full genome sequences for Rattus norvegicus (Rat) as provided by UCSC (rn6, Jul. 2014) and stored in Biostrings objects.
}

\details{
  
}

\note{
  This BSgenome data package was made from the following source data files:
  \preformatted{
rn6.2bit from http://hgdownload.cse.ucsc.edu/goldenPath/rn6/bigZips/
  }

  See \code{?\link[BSgenome]{BSgenomeForge}} and the BSgenomeForge
  vignette (\code{vignette("BSgenomeForge")}) in the \pkg{BSgenome}
  software package for how to make a BSgenome data package.
}

\author{The Bioconductor Dev Team}

\seealso{
  \itemize{
    \item \link[BSgenome]{BSgenome} objects and the
          \code{\link[BSgenome]{available.genomes}} function
          in the \pkg{BSgenome} software package.
    \item \link[Biostrings]{DNAString} objects in the \pkg{Biostrings}
          package.
    \item The BSgenomeForge vignette (\code{vignette("BSgenomeForge")})
          in the \pkg{BSgenome} software package for how to make a BSgenome
          data package.
  }
}

\examples{
BSgenome.Rnorvegicus.UCSC.rn6
genome <- BSgenome.Rnorvegicus.UCSC.rn6
seqlengths(genome)
genome$chr1  # same as genome[["chr1"]]

## ---------------------------------------------------------------------
## Extract the upstream sequences
## ---------------------------------------------------------------------
## The upstream sequences can easily be extracted from the full genome
## sequences with something like:

library(GenomicFeatures)
txdb <- makeTxDbFromUCSC("rn6", tablename="refGene")
up1000seqs <- extractUpstreamSeqs(genome, txdb, width=1000)

## IMPORTANT: Make sure you use a TxDb package (or TxDb object) that
## contains a gene model based on rn6 or on a compatible genome (i.e.
## a genome with sequences identical to the sequences in rn6). Note
## that you can make a TxDb object from various annotation resources.
## See the makeTxDbFromUCSC(), makeTxDbFromBiomart(), and
## makeTxDbFromGFF() functions in the GenomicFeatures package for more
## information.

## ---------------------------------------------------------------------
## Genome-wide motif searching
## ---------------------------------------------------------------------
## See the GenomeSearching vignette in the BSgenome software
## package for some examples of genome-wide motif searching using
## Biostrings and the BSgenome data packages:
if (interactive())
    vignette("GenomeSearching", package="BSgenome")
}

\keyword{package}
\keyword{data}
