###
###

.pkgname <- "BSgenome.Rnorvegicus.UCSC.rn6"

.seqnames <- NULL

.circ_seqs <- "chrM"

.mseqnames <- NULL

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Rattus norvegicus",
        species="Rat",
        provider="UCSC",
        provider_version="rn6",
        release_date="Jul. 2014",
        release_name="RGSC Rnor_6.0",
        source_url="http://hgdownload.cse.ucsc.edu/goldenPath/rn6/bigZips/",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

    old_objname <- "Rnorvegicus"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}

