###
###

.pkgname <- "BSgenome.Rnorvegicus.UCSC.rn5"

.seqnames <- paste("chr", c(1:20, "X", "M"), sep="")

.circ_seqs <- "chrM"

.mseqnames <- c("random", "chrUn")

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Rattus norvegicus",
        species="Rat",
        provider="UCSC",
        provider_version="rn5",
        release_date="Mar. 2012",
        release_name="RGSC 5.0",
        source_url="http://hgdownload.cse.ucsc.edu/goldenPath/rn5/bigZips/",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

    old_objname <- "Rnorvegicus"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}

