###
###

.pkgname <- "BSgenome.Ptroglodytes.UCSC.panTro3"

.seqnames <- paste("chr", c(1, "2A", "2B", 3:22, "X", "Y", "M"), sep="")

.circ_seqs <- "chrM"

.mseqnames <- c(paste("chr", c(1, "2A", "2B", 3:22, "X", "Y", "M"), "_random", sep=""), "chrUn")

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Pan troglodytes",
        species="Chimp",
        provider="UCSC",
        provider_version="panTro3",
        release_date="Oct. 2010",
        release_name="CGSC Build 2.1.3",
        source_url="http://hgdownload.cse.ucsc.edu/goldenPath/panTro3/bigZips/",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

    old_objname <- "Ptroglodytes"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}

