###
###

.pkgname <- "BSgenome.Mmusculus.UCSC.mm8"

.seqnames <- paste("chr", c(1:19, "X", "Y", "M", paste(c(1, 5, 7, 8, 9, 10, 13, 15, 17, "X", "Y", "Un"), "_random", sep="")), sep="")

.circ_seqs <- "chrM"

.mseqnames <- NULL

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Mus musculus",
        species="Mouse",
        provider="UCSC",
        provider_version="mm8",
        release_date="Feb. 2006",
        release_name="NCBI Build 36",
        source_url="http://hgdownload.cse.ucsc.edu/goldenPath/mm8/bigZips/",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

    old_objname <- "Mmusculus"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}

