###
###

.pkgname <- "BSgenome.Mmulatta.UCSC.rheMac3"

.seqnames <- paste("chr", c(1:20, "X", "M"), sep="")

.circ_seqs <- "chrM"

.mseqnames <- "chrUn"

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Macaca mulatta",
        species="Rhesus",
        provider="UCSC",
        provider_version="rheMac3",
        release_date="Oct. 2010",
        release_name="Beijing Genomics Institute CR_1.0",
        source_url="http://hgdownload.soe.ucsc.edu/goldenPath/rheMac3/",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

    old_objname <- "Mmulatta"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}

