###
###

.pkgname <- "BSgenome.Mfascicularis.NCBI.6.0"

.seqnames <- NULL

.circ_seqs <- character(0)

.mseqnames <- NULL

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Macaca fascicularis",
        common_name="Crab-eating macaque",
        genome="Macaca_fascicularis_6.0",
        provider="NCBI",
        release_date="2020/03/10",
        source_url="https://www.ncbi.nlm.nih.gov/assembly/GCA_011100615.1",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

    old_objname <- "Mfascicularis"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}

