\name{BSgenome.Hsapiens.UCSC.hs1}
\docType{package}

\alias{BSgenome.Hsapiens.UCSC.hs1-package}
\alias{BSgenome.Hsapiens.UCSC.hs1}
\alias{Hsapiens}

\title{Full genomic sequences for UCSC genome hs1 (Homo sapiens)}

\description{
  Full genomic sequences for UCSC genome hs1 (the hs1 genome is based on assembly T2T-CHM13v2.0, with GenBank assembly accession GCA_009914755.4). The sequences are stored in DNAString objects.
}

\details{
  
}

\note{
  This BSgenome data package was made from the following source data files:
  \preformatted{
hs1.2bit, downloaded from https://hgdownload.soe.ucsc.edu/goldenPath/hs1/bigZips/ on 2023-01-03
  }

  See \code{?\link[BSgenome]{BSgenomeForge}} and the BSgenomeForge
  vignette (\code{vignette("BSgenomeForge")}) in the \pkg{BSgenome}
  software package for how to make a BSgenome data package.
}

\author{The Bioconductor Dev Team}

\seealso{
  \itemize{
    \item \link[BSgenome]{BSgenome} objects and the
          \code{\link[BSgenome]{available.genomes}} function
          in the \pkg{BSgenome} software package.
    \item \link[Biostrings]{DNAString} objects in the \pkg{Biostrings}
          package.
    \item The BSgenomeForge vignette (\code{vignette("BSgenomeForge")})
          in the \pkg{BSgenome} software package for how to make a BSgenome
          data package.
  }
}

\examples{
BSgenome.Hsapiens.UCSC.hs1
genome <- BSgenome.Hsapiens.UCSC.hs1
head(seqlengths(genome))
genome$chr1  # same as genome[["chr1"]]

## ---------------------------------------------------------------------
## Genome-wide motif searching
## ---------------------------------------------------------------------
## See the GenomeSearching vignette in the BSgenome software
## package for some examples of genome-wide motif searching using
## Biostrings and the BSgenome data packages:
if (interactive())
    vignette("GenomeSearching", package="BSgenome")
}

\keyword{package}
\keyword{data}
