###
###

.pkgname <- "BSgenome.Hsapiens.UCSC.hg38.dbSNP151.minor"

.seqnames <- c("chr1", "chr2", "chr3", "chr4", "chr5", "chr6", "chr7", "chr8", 
"chr9", "chr10", "chr11", "chr12", "chr13", "chr14", "chr15", 
"chr16", "chr17", "chr18", "chr19", "chr20", "chr21", "chr22", 
"chrX", "chrY", "chrM", "chr1_GL383518v1_alt", "chr1_GL383519v1_alt", 
"chr1_GL383520v2_alt", "chr1_KI270759v1_alt", "chr1_KI270760v1_alt", 
"chr1_KI270761v1_alt", "chr1_KI270762v1_alt", "chr1_KI270763v1_alt", 
"chr1_KI270764v1_alt", "chr1_KI270765v1_alt", "chr1_KI270766v1_alt", 
"chr1_KI270892v1_alt", "chr2_GL383521v1_alt", "chr2_GL383522v1_alt", 
"chr2_GL582966v2_alt", "chr2_KI270767v1_alt", "chr2_KI270768v1_alt", 
"chr2_KI270769v1_alt", "chr2_KI270770v1_alt", "chr2_KI270771v1_alt", 
"chr2_KI270772v1_alt", "chr2_KI270773v1_alt", "chr2_KI270774v1_alt", 
"chr2_KI270775v1_alt", "chr2_KI270776v1_alt", "chr2_KI270893v1_alt", 
"chr2_KI270894v1_alt", "chr3_GL383526v1_alt", "chr3_JH636055v2_alt", 
"chr3_KI270777v1_alt", "chr3_KI270778v1_alt", "chr3_KI270779v1_alt", 
"chr3_KI270780v1_alt", "chr3_KI270781v1_alt", "chr3_KI270782v1_alt", 
"chr3_KI270783v1_alt", "chr3_KI270784v1_alt", "chr3_KI270895v1_alt", 
"chr3_KI270924v1_alt", "chr3_KI270934v1_alt", "chr3_KI270935v1_alt", 
"chr3_KI270936v1_alt", "chr3_KI270937v1_alt", "chr4_GL000257v2_alt", 
"chr4_GL383527v1_alt", "chr4_GL383528v1_alt", "chr4_KI270785v1_alt", 
"chr4_KI270786v1_alt", "chr4_KI270787v1_alt", "chr4_KI270788v1_alt", 
"chr4_KI270789v1_alt", "chr4_KI270790v1_alt", "chr4_KI270896v1_alt", 
"chr4_KI270925v1_alt", "chr5_GL339449v2_alt", "chr5_GL383530v1_alt", 
"chr5_GL383531v1_alt", "chr5_GL383532v1_alt", "chr5_GL949742v1_alt", 
"chr5_KI270791v1_alt", "chr5_KI270792v1_alt", "chr5_KI270793v1_alt", 
"chr5_KI270794v1_alt", "chr5_KI270795v1_alt", "chr5_KI270796v1_alt", 
"chr5_KI270897v1_alt", "chr5_KI270898v1_alt", "chr6_GL000250v2_alt", 
"chr6_GL000251v2_alt", "chr6_GL000252v2_alt", "chr6_GL000253v2_alt", 
"chr6_GL000254v2_alt", "chr6_GL000255v2_alt", "chr6_GL000256v2_alt", 
"chr6_GL383533v1_alt", "chr6_KB021644v2_alt", "chr6_KI270758v1_alt", 
"chr6_KI270797v1_alt", "chr6_KI270798v1_alt", "chr6_KI270799v1_alt", 
"chr6_KI270800v1_alt", "chr6_KI270801v1_alt", "chr6_KI270802v1_alt", 
"chr7_GL383534v2_alt", "chr7_KI270803v1_alt", "chr7_KI270804v1_alt", 
"chr7_KI270805v1_alt", "chr7_KI270806v1_alt", "chr7_KI270807v1_alt", 
"chr7_KI270808v1_alt", "chr7_KI270809v1_alt", "chr7_KI270899v1_alt", 
"chr8_KI270810v1_alt", "chr8_KI270811v1_alt", "chr8_KI270812v1_alt", 
"chr8_KI270813v1_alt", "chr8_KI270814v1_alt", "chr8_KI270815v1_alt", 
"chr8_KI270816v1_alt", "chr8_KI270817v1_alt", "chr8_KI270818v1_alt", 
"chr8_KI270819v1_alt", "chr8_KI270820v1_alt", "chr8_KI270821v1_alt", 
"chr8_KI270822v1_alt", "chr8_KI270900v1_alt", "chr8_KI270901v1_alt", 
"chr8_KI270926v1_alt", "chr9_GL383539v1_alt", "chr9_GL383540v1_alt", 
"chr9_GL383541v1_alt", "chr9_GL383542v1_alt", "chr9_KI270823v1_alt", 
"chr10_GL383545v1_alt", "chr10_GL383546v1_alt", "chr10_KI270824v1_alt", 
"chr10_KI270825v1_alt", "chr11_GL383547v1_alt", "chr11_JH159136v1_alt", 
"chr11_JH159137v1_alt", "chr11_KI270826v1_alt", "chr11_KI270827v1_alt", 
"chr11_KI270829v1_alt", "chr11_KI270830v1_alt", "chr11_KI270831v1_alt", 
"chr11_KI270832v1_alt", "chr11_KI270902v1_alt", "chr11_KI270903v1_alt", 
"chr11_KI270927v1_alt", "chr12_GL383549v1_alt", "chr12_GL383550v2_alt", 
"chr12_GL383551v1_alt", "chr12_GL383552v1_alt", "chr12_GL383553v2_alt", 
"chr12_GL877875v1_alt", "chr12_GL877876v1_alt", "chr12_KI270833v1_alt", 
"chr12_KI270834v1_alt", "chr12_KI270835v1_alt", "chr12_KI270836v1_alt", 
"chr12_KI270837v1_alt", "chr12_KI270904v1_alt", "chr13_KI270838v1_alt", 
"chr13_KI270839v1_alt", "chr13_KI270840v1_alt", "chr13_KI270841v1_alt", 
"chr13_KI270842v1_alt", "chr13_KI270843v1_alt", "chr14_KI270844v1_alt", 
"chr14_KI270845v1_alt", "chr14_KI270846v1_alt", "chr14_KI270847v1_alt", 
"chr15_GL383554v1_alt", "chr15_GL383555v2_alt", "chr15_KI270848v1_alt", 
"chr15_KI270849v1_alt", "chr15_KI270850v1_alt", "chr15_KI270851v1_alt", 
"chr15_KI270852v1_alt", "chr15_KI270905v1_alt", "chr15_KI270906v1_alt", 
"chr16_GL383556v1_alt", "chr16_GL383557v1_alt", "chr16_KI270853v1_alt", 
"chr16_KI270854v1_alt", "chr16_KI270855v1_alt", "chr16_KI270856v1_alt", 
"chr17_GL000258v2_alt", "chr17_GL383563v3_alt", "chr17_GL383564v2_alt", 
"chr17_GL383565v1_alt", "chr17_GL383566v1_alt", "chr17_JH159146v1_alt", 
"chr17_JH159147v1_alt", "chr17_JH159148v1_alt", "chr17_KI270857v1_alt", 
"chr17_KI270858v1_alt", "chr17_KI270859v1_alt", "chr17_KI270860v1_alt", 
"chr17_KI270861v1_alt", "chr17_KI270862v1_alt", "chr17_KI270907v1_alt", 
"chr17_KI270908v1_alt", "chr17_KI270909v1_alt", "chr17_KI270910v1_alt", 
"chr18_GL383567v1_alt", "chr18_GL383568v1_alt", "chr18_GL383569v1_alt", 
"chr18_GL383570v1_alt", "chr18_GL383571v1_alt", "chr18_GL383572v1_alt", 
"chr18_KI270863v1_alt", "chr18_KI270864v1_alt", "chr18_KI270911v1_alt", 
"chr18_KI270912v1_alt", "chr19_GL000209v2_alt", "chr19_GL383573v1_alt", 
"chr19_GL383574v1_alt", "chr19_GL383575v2_alt", "chr19_GL383576v1_alt", 
"chr19_GL949746v1_alt", "chr19_GL949747v2_alt", "chr19_GL949748v2_alt", 
"chr19_GL949749v2_alt", "chr19_GL949750v2_alt", "chr19_GL949751v2_alt", 
"chr19_GL949752v1_alt", "chr19_GL949753v2_alt", "chr19_KI270865v1_alt", 
"chr19_KI270866v1_alt", "chr19_KI270867v1_alt", "chr19_KI270868v1_alt", 
"chr19_KI270882v1_alt", "chr19_KI270883v1_alt", "chr19_KI270884v1_alt", 
"chr19_KI270885v1_alt", "chr19_KI270886v1_alt", "chr19_KI270887v1_alt", 
"chr19_KI270888v1_alt", "chr19_KI270889v1_alt", "chr19_KI270890v1_alt", 
"chr19_KI270891v1_alt", "chr19_KI270914v1_alt", "chr19_KI270915v1_alt", 
"chr19_KI270916v1_alt", "chr19_KI270917v1_alt", "chr19_KI270918v1_alt", 
"chr19_KI270919v1_alt", "chr19_KI270920v1_alt", "chr19_KI270921v1_alt", 
"chr19_KI270922v1_alt", "chr19_KI270923v1_alt", "chr19_KI270929v1_alt", 
"chr19_KI270930v1_alt", "chr19_KI270931v1_alt", "chr19_KI270932v1_alt", 
"chr19_KI270933v1_alt", "chr19_KI270938v1_alt", "chr20_GL383577v2_alt", 
"chr20_KI270869v1_alt", "chr20_KI270870v1_alt", "chr20_KI270871v1_alt", 
"chr21_GL383578v2_alt", "chr21_GL383579v2_alt", "chr21_GL383580v2_alt", 
"chr21_GL383581v2_alt", "chr21_KI270872v1_alt", "chr21_KI270873v1_alt", 
"chr21_KI270874v1_alt", "chr22_GL383582v2_alt", "chr22_GL383583v2_alt", 
"chr22_KB663609v1_alt", "chr22_KI270875v1_alt", "chr22_KI270876v1_alt", 
"chr22_KI270877v1_alt", "chr22_KI270878v1_alt", "chr22_KI270879v1_alt", 
"chr22_KI270928v1_alt", "chrX_KI270880v1_alt", "chrX_KI270881v1_alt", 
"chrX_KI270913v1_alt", "chr1_KI270706v1_random", "chr1_KI270707v1_random", 
"chr1_KI270708v1_random", "chr1_KI270709v1_random", "chr1_KI270710v1_random", 
"chr1_KI270711v1_random", "chr1_KI270712v1_random", "chr1_KI270713v1_random", 
"chr1_KI270714v1_random", "chr2_KI270715v1_random", "chr2_KI270716v1_random", 
"chr3_GL000221v1_random", "chr4_GL000008v2_random", "chr5_GL000208v1_random", 
"chr9_KI270717v1_random", "chr9_KI270718v1_random", "chr9_KI270719v1_random", 
"chr9_KI270720v1_random", "chr11_KI270721v1_random", "chr14_GL000009v2_random", 
"chr14_GL000194v1_random", "chr14_GL000225v1_random", "chr14_KI270722v1_random", 
"chr14_KI270723v1_random", "chr14_KI270724v1_random", "chr14_KI270725v1_random", 
"chr14_KI270726v1_random", "chr15_KI270727v1_random", "chr16_KI270728v1_random", 
"chr17_GL000205v2_random", "chr17_KI270729v1_random", "chr17_KI270730v1_random", 
"chr22_KI270731v1_random", "chr22_KI270732v1_random", "chr22_KI270733v1_random", 
"chr22_KI270734v1_random", "chr22_KI270735v1_random", "chr22_KI270736v1_random", 
"chr22_KI270737v1_random", "chr22_KI270738v1_random", "chr22_KI270739v1_random", 
"chrY_KI270740v1_random", "chrUn_GL000195v1", "chrUn_GL000213v1", 
"chrUn_GL000214v1", "chrUn_GL000216v2", "chrUn_GL000218v1", "chrUn_GL000219v1", 
"chrUn_GL000220v1", "chrUn_GL000224v1", "chrUn_GL000226v1", "chrUn_KI270302v1", 
"chrUn_KI270303v1", "chrUn_KI270304v1", "chrUn_KI270305v1", "chrUn_KI270310v1", 
"chrUn_KI270311v1", "chrUn_KI270312v1", "chrUn_KI270315v1", "chrUn_KI270316v1", 
"chrUn_KI270317v1", "chrUn_KI270320v1", "chrUn_KI270322v1", "chrUn_KI270329v1", 
"chrUn_KI270330v1", "chrUn_KI270333v1", "chrUn_KI270334v1", "chrUn_KI270335v1", 
"chrUn_KI270336v1", "chrUn_KI270337v1", "chrUn_KI270338v1", "chrUn_KI270340v1", 
"chrUn_KI270362v1", "chrUn_KI270363v1", "chrUn_KI270364v1", "chrUn_KI270366v1", 
"chrUn_KI270371v1", "chrUn_KI270372v1", "chrUn_KI270373v1", "chrUn_KI270374v1", 
"chrUn_KI270375v1", "chrUn_KI270376v1", "chrUn_KI270378v1", "chrUn_KI270379v1", 
"chrUn_KI270381v1", "chrUn_KI270382v1", "chrUn_KI270383v1", "chrUn_KI270384v1", 
"chrUn_KI270385v1", "chrUn_KI270386v1", "chrUn_KI270387v1", "chrUn_KI270388v1", 
"chrUn_KI270389v1", "chrUn_KI270390v1", "chrUn_KI270391v1", "chrUn_KI270392v1", 
"chrUn_KI270393v1", "chrUn_KI270394v1", "chrUn_KI270395v1", "chrUn_KI270396v1", 
"chrUn_KI270411v1", "chrUn_KI270412v1", "chrUn_KI270414v1", "chrUn_KI270417v1", 
"chrUn_KI270418v1", "chrUn_KI270419v1", "chrUn_KI270420v1", "chrUn_KI270422v1", 
"chrUn_KI270423v1", "chrUn_KI270424v1", "chrUn_KI270425v1", "chrUn_KI270429v1", 
"chrUn_KI270435v1", "chrUn_KI270438v1", "chrUn_KI270442v1", "chrUn_KI270448v1", 
"chrUn_KI270465v1", "chrUn_KI270466v1", "chrUn_KI270467v1", "chrUn_KI270468v1", 
"chrUn_KI270507v1", "chrUn_KI270508v1", "chrUn_KI270509v1", "chrUn_KI270510v1", 
"chrUn_KI270511v1", "chrUn_KI270512v1", "chrUn_KI270515v1", "chrUn_KI270516v1", 
"chrUn_KI270517v1", "chrUn_KI270518v1", "chrUn_KI270519v1", "chrUn_KI270521v1", 
"chrUn_KI270522v1", "chrUn_KI270528v1", "chrUn_KI270529v1", "chrUn_KI270530v1", 
"chrUn_KI270538v1", "chrUn_KI270539v1", "chrUn_KI270544v1", "chrUn_KI270548v1", 
"chrUn_KI270579v1", "chrUn_KI270580v1", "chrUn_KI270581v1", "chrUn_KI270582v1", 
"chrUn_KI270583v1", "chrUn_KI270584v1", "chrUn_KI270587v1", "chrUn_KI270588v1", 
"chrUn_KI270589v1", "chrUn_KI270590v1", "chrUn_KI270591v1", "chrUn_KI270593v1", 
"chrUn_KI270741v1", "chrUn_KI270742v1", "chrUn_KI270743v1", "chrUn_KI270744v1", 
"chrUn_KI270745v1", "chrUn_KI270746v1", "chrUn_KI270747v1", "chrUn_KI270748v1", 
"chrUn_KI270749v1", "chrUn_KI270750v1", "chrUn_KI270751v1", "chrUn_KI270752v1", 
"chrUn_KI270753v1", "chrUn_KI270754v1", "chrUn_KI270755v1", "chrUn_KI270756v1", 
"chrUn_KI270757v1", "chr1_KN196472v1_fix", "chr1_KN196473v1_fix", 
"chr1_KN196474v1_fix", "chr1_KN538360v1_fix", "chr1_KN538361v1_fix", 
"chr1_KQ031383v1_fix", "chr1_KZ208906v1_fix", "chr1_KZ559100v1_fix", 
"chr2_KN538362v1_fix", "chr2_KN538363v1_fix", "chr2_KQ031384v1_fix", 
"chr3_KN196475v1_fix", "chr3_KN196476v1_fix", "chr3_KN538364v1_fix", 
"chr3_KQ031385v1_fix", "chr3_KQ031386v1_fix", "chr3_KV766192v1_fix", 
"chr3_KZ559104v1_fix", "chr4_KQ983257v1_fix", "chr5_KV575244v1_fix", 
"chr6_KN196478v1_fix", "chr6_KQ031387v1_fix", "chr6_KQ090016v1_fix", 
"chr6_KV766194v1_fix", "chr6_KZ208911v1_fix", "chr7_KQ031388v1_fix", 
"chr7_KV880764v1_fix", "chr7_KV880765v1_fix", "chr7_KZ208912v1_fix", 
"chr8_KV880766v1_fix", "chr8_KV880767v1_fix", "chr8_KZ208914v1_fix", 
"chr8_KZ208915v1_fix", "chr9_KN196479v1_fix", "chr10_KN196480v1_fix", 
"chr10_KN538365v1_fix", "chr10_KN538366v1_fix", "chr10_KN538367v1_fix", 
"chr10_KQ090021v1_fix", "chr11_KN196481v1_fix", "chr11_KQ090022v1_fix", 
"chr11_KQ759759v1_fix", "chr11_KV766195v1_fix", "chr11_KZ559108v1_fix", 
"chr11_KZ559109v1_fix", "chr12_KN196482v1_fix", "chr12_KN538369v1_fix", 
"chr12_KN538370v1_fix", "chr12_KQ759760v1_fix", "chr12_KZ208916v1_fix", 
"chr12_KZ208917v1_fix", "chr13_KN196483v1_fix", "chr13_KN538371v1_fix", 
"chr13_KN538372v1_fix", "chr13_KN538373v1_fix", "chr14_KZ208920v1_fix", 
"chr15_KN538374v1_fix", "chr16_KV880768v1_fix", "chr16_KZ559113v1_fix", 
"chr17_KV575245v1_fix", "chr17_KV766196v1_fix", "chr18_KQ090028v1_fix", 
"chr18_KZ208922v1_fix", "chr18_KZ559115v1_fix", "chr19_KN196484v1_fix", 
"chr19_KQ458386v1_fix", "chr22_KQ759762v1_fix", "chrY_KN196487v1_fix", 
"chrY_KZ208923v1_fix", "chrY_KZ208924v1_fix", "chr1_KQ458382v1_alt", 
"chr1_KQ458383v1_alt", "chr1_KQ458384v1_alt", "chr1_KQ983255v1_alt", 
"chr1_KV880763v1_alt", "chr1_KZ208904v1_alt", "chr1_KZ208905v1_alt", 
"chr2_KQ983256v1_alt", "chr2_KZ208907v1_alt", "chr2_KZ208908v1_alt", 
"chr3_KZ208909v1_alt", "chr3_KZ559101v1_alt", "chr3_KZ559102v1_alt", 
"chr3_KZ559103v1_alt", "chr3_KZ559105v1_alt", "chr4_KQ090013v1_alt", 
"chr4_KQ090014v1_alt", "chr4_KQ090015v1_alt", "chr4_KQ983258v1_alt", 
"chr4_KV766193v1_alt", "chr5_KN196477v1_alt", "chr5_KV575243v1_alt", 
"chr5_KZ208910v1_alt", "chr6_KQ090017v1_alt", "chr7_KZ208913v1_alt", 
"chr7_KZ559106v1_alt", "chr8_KZ559107v1_alt", "chr9_KQ090018v1_alt", 
"chr9_KQ090019v1_alt", "chr10_KQ090020v1_alt", "chr11_KN538368v1_alt", 
"chr11_KZ559110v1_alt", "chr11_KZ559111v1_alt", "chr12_KQ090023v1_alt", 
"chr12_KZ208918v1_alt", "chr12_KZ559112v1_alt", "chr13_KQ090024v1_alt", 
"chr13_KQ090025v1_alt", "chr14_KZ208919v1_alt", "chr15_KQ031389v1_alt", 
"chr16_KQ031390v1_alt", "chr16_KQ090026v1_alt", "chr16_KQ090027v1_alt", 
"chr16_KZ208921v1_alt", "chr17_KV766197v1_alt", "chr17_KV766198v1_alt", 
"chr17_KZ559114v1_alt", "chr18_KQ458385v1_alt", "chr18_KZ559116v1_alt", 
"chr19_KV575246v1_alt", "chr19_KV575247v1_alt", "chr19_KV575248v1_alt", 
"chr19_KV575249v1_alt", "chr19_KV575250v1_alt", "chr19_KV575251v1_alt", 
"chr19_KV575252v1_alt", "chr19_KV575253v1_alt", "chr19_KV575254v1_alt", 
"chr19_KV575255v1_alt", "chr19_KV575256v1_alt", "chr19_KV575257v1_alt", 
"chr19_KV575258v1_alt", "chr19_KV575259v1_alt", "chr19_KV575260v1_alt", 
"chr22_KN196485v1_alt", "chr22_KN196486v1_alt", "chr22_KQ458387v1_alt", 
"chr22_KQ458388v1_alt", "chr22_KQ759761v1_alt", "chrX_KV766199v1_alt")

.circ_seqs <- "chrM"

.mseqnames <- NULL

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Homo sapiens",
        common_name="Human",
        provider="UCSC",
        provider_version="hg38",
        release_date="Dec. 2017",
        release_name="Genome Reference Consortium GRCh38.p12",
        source_url="https://hgdownload.cse.ucsc.edu/goldenPath/hg38/bigZips/latest/",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

}

