###
###

.pkgname <- "BSgenome.Hsapiens.UCSC.hg19"

.seqnames <- NULL

.circ_seqs <- c("chrM", "chrMT")

.mseqnames <- NULL

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Homo sapiens",
        common_name="Human",
        provider="UCSC",
        provider_version="hg19",
        release_date="June 2013",
        release_name="Genome Reference Consortium GRCh37.p13",
        source_url="https://hgdownload.cse.ucsc.edu/goldenPath/hg19/bigZips/latest/",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

    old_objname <- "Hsapiens"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}

