###
###

.pkgname <- "BSgenome.Hsapiens.UCSC.hg17"

.seqnames <- paste("chr", c(1:22, "X", "Y", "M", "6_hla_hap1", "6_hla_hap2", paste(c((1:22)[-c(11, 14, 20, 21)], "X"), "_random", sep="")), sep="")

.circ_seqs <- "chrM"

.mseqnames <- NULL

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Homo sapiens",
        species="Human",
        provider="UCSC",
        provider_version="hg17",
        release_date="May 2004",
        release_name="NCBI Build 35",
        source_url="http://hgdownload.cse.ucsc.edu/goldenPath/hg17/bigZips/",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

    old_objname <- "Hsapiens"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}

.onAttach <- function(libname, pkgname) {
    msg <- sprintf(
        "Package '%s' is deprecated and will be removed from Bioconductor
         version %s", pkgname, "3.21")
    .Deprecated(msg=paste(strwrap(msg, exdent=2), collapse="\n"))
}

