###
###

.pkgname <- "BSgenome.Hsapiens.UCSC.hg17.masked"

.nmask_per_seq <- 4

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export MaskedBSgenome object.
    bsgenome <- MaskedBSgenome(
        ref_bsgenome=BSgenome.Hsapiens.UCSC.hg17,
        masks_pkgname=pkgname,
        nmask_per_seq=.nmask_per_seq,
        masks_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)
}

.onAttach <- function(libname, pkgname) {
    msg <- sprintf(
        "Package '%s' is deprecated and will be removed from Bioconductor
         version %s", pkgname, "3.21")
    .Deprecated(msg=paste(strwrap(msg, exdent=2), collapse="\n"))
}

