###
###

.pkgname <- "BSgenome.Ggallus.UCSC.galGal5"

.seqnames <- NULL

.circ_seqs <- "chrM"

.mseqnames <- NULL

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Gallus gallus",
        common_name="Chicken",
        provider="UCSC",
        provider_version="galGal5",
        release_date="Dec. 2015",
        release_name="ICGC Gallus-gallus-5.0",
        source_url="http://hgdownload.cse.ucsc.edu/goldenPath/galGal5/bigZips/",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

    old_objname <- "Ggallus"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}

