###
###

.pkgname <- "BSgenome.Ggallus.UCSC.galGal3"

.seqnames <- paste("chr", c(1:28, 32, "M", "W", "Z", "E64", "E22C19W28_E50C23", paste(c(1:2, 4:8, 10:13, 16:18, 20, 22, 25, 28, "W", "Z", "E64", "E22C19W28_E50C23", "Un"), "_random", sep="")), sep="")

.circ_seqs <- "chrM"

.mseqnames <- NULL

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Gallus gallus",
        species="Chicken",
        provider="UCSC",
        provider_version="galGal3",
        release_date="May 2006",
        release_name="WUSTL Gallus-gallus-2.1",
        source_url="http://hgdownload.cse.ucsc.edu/goldenPath/galGal3/bigZips/",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

    old_objname <- "Ggallus"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}

