###
###

.pkgname <- "BSgenome.Drerio.UCSC.danRer7"

.seqnames <- paste("chr", c(1:25, "M"), sep="")

.circ_seqs <- "chrM"

.mseqnames <- c("Zv9_NA", "Zv9_scaffold")

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Danio rerio",
        species="Zebrafish",
        provider="UCSC",
        provider_version="danRer7",
        release_date="Jul. 2010",
        release_name="Sanger Institute Zv9",
        source_url="http://hgdownload.cse.ucsc.edu/goldenPath/danRer7/",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

    old_objname <- "Drerio"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}

