\name{BSgenome.Creinhardtii.JGI.v5.6}
\docType{package}

\alias{BSgenome.Creinhardtii.JGI.v5.6-package}
\alias{BSgenome.Creinhardtii.JGI.v5.6}
\alias{Creinhardtii}

\title{Full genome sequences for Chlamydomonas reinhardtii (v5.6)}

\description{
  Full genome sequences for Chlamydomonas reinhardtii (v5.6) as provided by JGI and stored in Biostrings objects. The data in this package is public. See 'citation("BSgenome.Creinhardtii.JGI.v5.6")' for how to cite in publications.
}

\details{
  
}

\note{
  This BSgenome data package was made from the following source data files:
  \preformatted{
Creinhardtii_281_v5.0.fa.gz from https://phytozome-next.jgi.doe.gov/info/Creinhardtii_v5_6
  }

  See \code{?\link[BSgenome]{BSgenomeForge}} and the BSgenomeForge
  vignette (\code{vignette("BSgenomeForge")}) in the \pkg{BSgenome}
  software package for how to make a BSgenome data package.
}

\author{The Bioconductor Dev Team}

\seealso{
  \itemize{
    \item \link[BSgenome]{BSgenome} objects and the
          \code{\link[BSgenome]{available.genomes}} function
          in the \pkg{BSgenome} software package.
    \item \link[Biostrings]{DNAString} objects in the \pkg{Biostrings}
          package.
    \item The BSgenomeForge vignette (\code{vignette("BSgenomeForge")})
          in the \pkg{BSgenome} software package for how to make a BSgenome
          data package.
  }
}

\examples{
BSgenome.Creinhardtii.JGI.v5.6
genome <- BSgenome.Creinhardtii.JGI.v5.6
head(seqlengths(genome))
genome[["chromosome_1"]]

## ---------------------------------------------------------------------
## Genome-wide motif searching
## ---------------------------------------------------------------------
## See the GenomeSearching vignette in the BSgenome software
## package for some examples of genome-wide motif searching using
## Biostrings and the BSgenome data packages:
if (interactive())
    vignette("GenomeSearching", package="BSgenome")
}

\keyword{package}
\keyword{data}
