\name{BSgenome.Celegans.UCSC.ce11}
\docType{package}

\alias{BSgenome.Celegans.UCSC.ce11-package}
\alias{BSgenome.Celegans.UCSC.ce11}
\alias{Celegans}

\title{Full genome sequences for Caenorhabditis elegans (UCSC version ce11)}

\description{
  Full genome sequences for Caenorhabditis elegans (Worm) as provided by UCSC (ce11, Feb. 2013) and stored in Biostrings objects.
}

\details{
  
}

\note{
  This BSgenome data package was made from the following source data files:
  \preformatted{
ce11.2bit from http://hgdownload.soe.ucsc.edu/goldenPath/ce11/bigZips/
  }

  See \code{?\link[BSgenome]{BSgenomeForge}} and the BSgenomeForge
  vignette (\code{vignette("BSgenomeForge")}) in the \pkg{BSgenome}
  software package for how to make a BSgenome data package.
}

\author{The Bioconductor Dev Team}

\seealso{
  \itemize{
    \item \link[BSgenome]{BSgenome} objects and the
          \code{\link[BSgenome]{available.genomes}} function
          in the \pkg{BSgenome} software package.
    \item \link[Biostrings]{DNAString} objects in the \pkg{Biostrings}
          package.
    \item The BSgenomeForge vignette (\code{vignette("BSgenomeForge")})
          in the \pkg{BSgenome} software package for how to make a BSgenome
          data package.
  }
}

\examples{
BSgenome.Celegans.UCSC.ce11
genome <- BSgenome.Celegans.UCSC.ce11
head(seqlengths(genome))
genome$chrI  # same as genome[["chrI"]]

## ---------------------------------------------------------------------
## Genome-wide motif searching
## ---------------------------------------------------------------------
## See the GenomeSearching vignette in the BSgenome software
## package for some examples of genome-wide motif searching using
## Biostrings and the BSgenome data packages:
if (interactive())
    vignette("GenomeSearching", package="BSgenome")
}

\keyword{package}
\keyword{data}
