\name{BSgenome.Btaurus.UCSC.bosTau9}
\docType{package}

\alias{BSgenome.Btaurus.UCSC.bosTau9-package}
\alias{BSgenome.Btaurus.UCSC.bosTau9}
\alias{Btaurus}

\title{Full genome sequences for Bos taurus (UCSC version bosTau9)}

\description{
  Full genome sequences for Bos taurus (Cow) as provided by UCSC (bosTau9, Apr. 2018) and stored in Biostrings objects.
}

\details{
  
}

\note{
  This BSgenome data package was made from the following source data files:
  \preformatted{
bosTau9.2bit from http://hgdownload.cse.ucsc.edu/goldenPath/bosTau9/bigZips/
  }

  See \code{?\link[BSgenome]{BSgenomeForge}} and the BSgenomeForge
  vignette (\code{vignette("BSgenomeForge")}) in the \pkg{BSgenome}
  software package for how to make a BSgenome data package.
}

\author{The Bioconductor Dev Team}

\seealso{
  \itemize{
    \item \link[BSgenome]{BSgenome} objects and the
          \code{\link[BSgenome]{available.genomes}} function
          in the \pkg{BSgenome} software package.
    \item \link[Biostrings]{DNAString} objects in the \pkg{Biostrings}
          package.
    \item The BSgenomeForge vignette (\code{vignette("BSgenomeForge")})
          in the \pkg{BSgenome} software package for how to make a BSgenome
          data package.
  }
}

\examples{
BSgenome.Btaurus.UCSC.bosTau9
genome <- BSgenome.Btaurus.UCSC.bosTau9
head(seqlengths(genome))
genome$chr1  # same as genome[["chr1"]]

## ---------------------------------------------------------------------
## Extract the upstream sequences
## ---------------------------------------------------------------------
## The upstream sequences located in
##   http://hgdownload.cse.ucsc.edu/goldenPath/bosTau9/bigZips/
## are based on RefSeq genes (RefSeq Genes track in the Genome Browser).
## These can easily be extracted from the full genome sequences with:

library(GenomicFeatures)
refGene_txdb <- suppressWarnings(makeTxDbFromUCSC("bosTau9", "refGene"))
refGene_up1000seqs <- extractUpstreamSeqs(genome, refGene_txdb)

## Note that you can make a TxDb object from various annotation
## resources. See the makeTxDbFromUCSC(), makeTxDbFromEnsembl(), and
## makeTxDbFromGFF() functions in the GenomicFeatures package for more
## information.
## IMPORTANT: Make sure you use a TxDb package (or TxDb object) that
## contains a gene model based on bosTau9 or on a compatible genome
## (i.e. a genome with sequences identical to the sequences in bosTau9).
## See ?extractUpstreamSeqs in the GenomicFeatures package for more
## information.

## ---------------------------------------------------------------------
## Genome-wide motif searching
## ---------------------------------------------------------------------
## See the GenomeSearching vignette in the BSgenome software
## package for some examples of genome-wide motif searching using
## Biostrings and the BSgenome data packages:
if (interactive())
    vignette("GenomeSearching", package="BSgenome")
}

\keyword{package}
\keyword{data}
