###
###

.pkgname <- "BSgenome.Btaurus.UCSC.bosTau9"

.seqnames <- NULL

.circ_seqs <- "chrM"

.mseqnames <- NULL

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Bos taurus",
        common_name="Cow",
        provider="UCSC",
        provider_version="bosTau9",
        release_date="Apr. 2018",
        release_name="USDA ARS",
        source_url="http://hgdownload.cse.ucsc.edu/goldenPath/bosTau9/bigZips/",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

    old_objname <- "Btaurus"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}

