###
###

.pkgname <- "BSgenome.Amellifera.NCBI.AmelHAv3.1"

.seqnames <- NULL

.circ_seqs <- "MT"

.mseqnames <- NULL

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Apis mellifera",
        common_name="Honey bee",
        genome="Amel_HAv3.1",
        provider="NCBI",
        release_date="2018/09/10",
        source_url="https://www.ncbi.nlm.nih.gov/assembly/GCF_003254395.2",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

    old_objname <- "Amellifera"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}

