\name{Alyrata}
\docType{package}

\alias{BSgenome.Alyrata.JGI.v1-package}
\alias{BSgenome.Alyrata.JGI.v1}
\alias{Alyrata}


\title{Arabidopsis lyrata full genome (JGI version V1.0)}

\description{
  Arabidopsis lyrata 8x Release [project ID 4002920] as provided by JGI ( snapshot from March 24, 2011) and stored in Biostrings objects.
}

\details{
  
}

\note{
  This BSgenome data package was made from the following source data files:
  \preformatted{
all the chr*.fa file from http://genome.jgi-psf.org/Araly1/Araly1.download.ftp.html
Chloroplast and mitochondrion genomes are presented as scaffolds, see JGI websites for INFO.
WARNING: This is where things are today (March 24, 2011) but is probably
NOT aimed to be the permanent URL for the V1.0 snapshot of the genome.
JGI might update the content of this folder in the future with a new
snapshot and move the V1.0 snapshot to the OLD/ subfolder.

  }
  See \code{?\link[BSgenome]{BSgenomeForge}} and the BSgenomeForge
  vignette (\code{vignette("BSgenomeForge")}) in the BSgenome software
  package for how to make a BSgenome data package.
}

\author{Jian-Feng Mao and Ya-Long Guo, with acknowledgement to Detlef Weigel}

\seealso{
  \link[BSgenome]{BSgenome-class},
  \link[Biostrings]{DNAString-class},
  \code{\link[BSgenome]{available.genomes}},
  \link[BSgenome]{BSgenomeForge}
}

\examples{
Alyrata
seqlengths(Alyrata)
Alyrata$chr1  # same as Alyrata[["chr1"]]

## ---------------------------------------------------------------------
## Genome-wide motif searching
## ---------------------------------------------------------------------
## See the GenomeSearching vignette in the BSgenome software
## package for some examples of genome-wide motif searching using
## Biostrings and the BSgenome data packages:
if (interactive())
    vignette("GenomeSearching", package="BSgenome")
}

\keyword{package}
\keyword{data}
