% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inherited_functions.R
\name{quantile}
\alias{quantile}
\alias{quantile.Zi}
\title{Calculate the quantiles of zero-deinflated count data}
\usage{
\method{quantile}{Zi}(x, probs = seq(0, 1, 0.25), na.rm = TRUE, ...)
}
\arguments{
\item{x}{A \code{\linkS4class{Zi}}-class object}

\item{probs}{A numeric \code{\link[base]{vector}} of J probabilities in
[0,1]}

\item{na.rm}{\code{\link[base]{logical}} If \code{\link{TRUE}} NAs are
excluded, otherwise not. default = \code{\link{TRUE}}}

\item{...}{\link[stats]{quantile}}
}
\value{
quantile value
}
\description{
Calculate the quantiles of  zero-deinflated data of a
\code{\linkS4class{Zi}}-class object. To calculate the quantiles, the
deinflatedcounts matrix will be extracted.
}
\examples{
data(mtx)
Zi <- ziMain(mtx)
quantile(Zi)
}
\seealso{
\link[stats]{quantile}, \link[zitools]{rowQuantiles},
\link[zitools]{colQuantiles}
}
