% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/helper_methods.R
\name{zinbSim}
\alias{zinbSim}
\alias{zinbSim,ZinbModel-method}
\title{Simulate counts from a zero-inflated negative binomial model}
\usage{
zinbSim(object, seed, ...)

\S4method{zinbSim}{ZinbModel}(object, seed)
}
\arguments{
\item{object}{an object that describes a matrix of zero-inflated negative
binomial.}

\item{seed}{an optional integer to specify how the random number generator
should be initialized with a call to \code{set.seed}. If missing, the
random generator state is not changed.}

\item{...}{additional arguments.}
}
\value{
A list with the following elements.
  \itemize{
  \item{counts}{the matrix with the simulated counts.}
  \item{dataNB}{the data simulated from the negative binomial.}
  \item{dataDropouts}{the data simulated from the binomial process.}
  \item{zeroFraction}{the fraction of zeros.}
  }
}
\description{
Given an object that describes zero-inflated negative binomial distribution,
simulate counts from the distribution.
}
\section{Methods (by class)}{
\itemize{
\item \code{zinbSim(ZinbModel)}: simulate from a ZINB distribution.

}}
\examples{
a <- zinbModel(n=5, J=10)
zinbSim(a)
}
