% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solveRidgeRegression.R
\name{solveRidgeRegression}
\alias{solveRidgeRegression}
\title{Solve ridge regression or logistic regression problems}
\usage{
solveRidgeRegression(
  x,
  y,
  beta = rep(0, NCOL(x)),
  epsilon = 1e-06,
  family = c("gaussian", "binomial"),
  offset = rep(0, NROW(x))
)
}
\arguments{
\item{x}{a matrix of covariates, one sample per row, one covariate per
column.}

\item{y}{a vector of response (continuous for regression, 0/1 binary for
logistic regression)}

\item{beta}{an initial solution where optimization starts (null vector by
default)}

\item{epsilon}{a scalar or vector of regularization parameters (default
\code{1e-6})}

\item{family}{a string to choose the type of regression (default
\code{family="gaussian"})}

\item{offset}{a vector of offsets (default null vector)}
}
\value{
A vector solution of the regression problem
}
\description{
This function solves a regression or logistic regression problem regularized
by a L2 or weighted L2 penalty. Contrary to \code{lm.ridge} or \code{glmnet},
it works for any number of predictors.
}
\details{
When \code{family="gaussian"}, we solve the ridge regression problem
  that finds the \eqn{\beta} that minimizes: \deqn{||y - x \beta||^2 +
  \epsilon||\beta||^2/2 .} When \code{family="binomial"} we solve the ridge
  logistic regression problem \deqn{min \sum_i [-y_i (x \beta)_i +
  log(1+exp(x\beta)_i)) ] + \epsilon||\beta||^2/2 .} When \code{epsilon} is a
  vector of size equal to the size of \code{beta}, then the penalty is a
  weighted L2 norm \eqn{\sum_i \epsilon_i \beta_i^2 / 2}.
}
