% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zinbwave.R
\name{imputeZeros}
\alias{imputeZeros}
\title{Impute the zeros using the estimated parameters from the ZINB model.}
\usage{
imputeZeros(model, x)
}
\arguments{
\item{model}{the zinb model}

\item{x}{the matrix of counts n cells by J genes}
}
\value{
the matrix of imputed counts.
}
\description{
Given a matrix of counts and a zinb model, this function computes the
imputed counts under a zero-inflated negative binomial
(ZINB) model.
}
\examples{
se <- SummarizedExperiment(matrix(rpois(60, lambda=5), nrow=10, ncol=6),
    colData = data.frame(bio = gl(2, 3)))
m <- zinbFit(se, X=model.matrix(~bio, data=colData(se)),
    BPPARAM=BiocParallel::SerialParam())
imputeZeros(m, t(assay(se)))
}
