% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R
\name{writeH5AD}
\alias{writeH5AD}
\title{Write H5AD}
\usage{
writeH5AD(
  sce,
  file,
  X_name = NULL,
  skip_assays = FALSE,
  compression = c("none", "gzip", "lzf"),
  version = NULL,
  verbose = NULL,
  ...
)
}
\arguments{
\item{sce}{A \link[SingleCellExperiment:SingleCellExperiment-class]{SingleCellExperiment::SingleCellExperiment}
object.}

\item{file}{String containing a path to write the new \code{.h5ad} file.}

\item{X_name}{Name of the assay to use as the primary matrix (\code{X}) of the
AnnData object. If \code{NULL}, the first assay of \code{sce} will be used by default.}

\item{skip_assays}{Logical scalar indicating whether assay matrices should
be ignored when writing to \code{file}.}

\item{compression}{Type of compression when writing the new \code{.h5ad} file.}

\item{version}{A string giving the version of the \strong{anndata} Python library
to use. Allowed values are available in \code{.AnnDataVersions}. By default the
latest version is used.}

\item{verbose}{Logical scalar indicating whether to print progress messages.
If \code{NULL} uses \code{getOption("zellkonverter.verbose")}.}

\item{...}{
  Arguments passed on to \code{\link[=SCE2AnnData]{SCE2AnnData}}
  \describe{
    \item{\code{assays,colData,rowData,reducedDims,metadata,colPairs,rowPairs}}{Arguments specifying how these slots are converted. If \code{TRUE} everything in
that slot is converted, if \code{FALSE} nothing is converted and if a character
vector only those items or columns are converted.}
  }}
}
\value{
A \code{NULL} is invisibly returned.
}
\description{
Write a H5AD file from a
\link[SingleCellExperiment:SingleCellExperiment-class]{SingleCellExperiment::SingleCellExperiment}
object.
}
\details{
\subsection{Skipping assays}{

Setting \code{skip_assays = TRUE} can occasionally be useful if the matrices in
\code{sce} are stored in a format that is not amenable for efficient conversion
to a \strong{numpy}-compatible format. In such cases, it can be better to create
an empty placeholder dataset in \code{file} and fill it in R afterwards.
}

\subsection{\strong{DelayedArray} assays}{

If \code{sce} contains any \strong{DelayedArray} matrices as assays \code{writeH5AD()} will
write them to disk using the \strong{rhdf5} package directly rather than via
Python to avoid instantiating them in memory. However there is currently
an issue which prevents this being done for sparse \strong{DelayedArray} matrices.
}

\subsection{Known conversion issues}{
\subsection{Coercion to factors}{

The \strong{anndata} package automatically converts some character vectors to
factors when saving \code{.h5ad} files. This can effect columns of \code{rowData(sce)}
and \code{colData(sce)} which may change type when the \code{.h5ad} file is read back
into R.
}

}

\subsection{Environment}{

See \link{AnnData-Environment} for more details on \strong{zellkonverter} Python
environments.
}
}
\examples{
# Using the Zeisel brain dataset
if (requireNamespace("scRNAseq", quietly = TRUE)) {
    library(scRNAseq)
    sce <- ZeiselBrainData()

    # Writing to a H5AD file
    temp <- tempfile(fileext = ".h5ad")
    writeH5AD(sce, temp)
}
}
\seealso{
\code{\link[=readH5AD]{readH5AD()}}, to read a
\link[SingleCellExperiment:SingleCellExperiment-class]{SingleCellExperiment::SingleCellExperiment}
object from a H5AD file.

\code{\link[=SCE2AnnData]{SCE2AnnData()}}, for developers to create an AnnData object from a
\link[SingleCellExperiment:SingleCellExperiment-class]{SingleCellExperiment::SingleCellExperiment}.
}
\author{
Luke Zappia

Aaron Lun
}
